/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.PieChartInfo;
import jclass.chart.PieData;

public class JCLegend
extends ChartCanvas {
    int anchor = 1;
    int orientation = 1;
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTHEAST = 17;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 33;
    public static final int SOUTHWEST = 34;
    public static final int NORTHSOUTH_MASK = 240;
    public static final int EASTWEST_MASK = 15;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    Object[] labelSizes;
    int[] colWidths;
    int[] rowHeights;
    int[] symWidths;
    int[] strWidths;
    int symbolSize = 8;
    int smallGap = 2;
    int betweenGap = 5;
    int descent;

    public JCLegend() {
        this.isShowing = false;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public synchronized void setAnchor(int n) {
        if (n == this.anchor) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 34: {
                this.anchor = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Anchor value in JCLegend.  Should be one of NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST or SOUTHWEST");
    }

    public synchronized void setOrientation(int n) {
        if (n == this.orientation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value for Orientation in JCLegend.  Should be one of VERTICAL or HORIZONTAL");
    }

    public void recalc() {
        int n;
        Dimension[] dimensionArray;
        if (!this.isChanged()) {
            return;
        }
        super.preferredSize();
        if (!this.isShowing) {
            this.setChanged(false);
            return;
        }
        boolean bl = this.orientation == 1;
        this.labelSizes = new Object[this.chart.data.size()];
        int n2 = 0;
        if (this.chart == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.chart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.chart.data.elementAt(n3);
            chartDataView.calcTransientData();
            ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
            if (chartDataViewSeriesArray != null && chartDataViewSeriesArray.length != 0) {
                Font font;
                Dimension[] dimensionArray2;
                if (n2 < chartDataViewSeriesArray.length) {
                    n2 = chartDataViewSeriesArray.length + 2;
                }
                this.labelSizes[n3] = dimensionArray2 = new Dimension[n2 * 2];
                try {
                    Graphics graphics = this.getGraphics();
                    font = graphics.getFont();
                }
                catch (Exception exception) {
                    System.err.println("Problem getting Font : " + exception);
                    exception.printStackTrace();
                    font = new Font("helvetica", 0, 12);
                }
                dimensionArray = Toolkit.getDefaultToolkit().getFontMetrics(font);
                this.descent = dimensionArray.getDescent();
                this.symbolSize = dimensionArray.getAscent();
                if (!chartDataView.getIsShowingInLegend()) {
                    dimensionArray2[0] = new Dimension(0, 0);
                    dimensionArray2[1] = new Dimension(0, 0);
                } else {
                    Object object;
                    Object object2 = chartDataView.getName();
                    dimensionArray2[0] = new Dimension(0, 0);
                    if (object2 == null || ((String)object2).length() == 0) {
                        object2 = "";
                        dimensionArray2[1] = new Dimension(0, 0);
                    } else {
                        dimensionArray2[1] = new Dimension(dimensionArray.stringWidth((String)object2) + this.smallGap, dimensionArray.getHeight() + this.smallGap);
                    }
                    if (chartDataView.getChartType() == 11) {
                        object2 = (PieChartInfo)chartDataView.getTransientData();
                        if (object2 != null) {
                            int n4 = 0;
                            while (n4 < ((PieChartInfo)object2).num_pies) {
                                object = ((PieChartInfo)object2).data[n4];
                                int n5 = 0;
                                while (n5 < ((PieData)object).num_slices_pie) {
                                    if (n5 == ((PieData)object).other_slice) {
                                        if (dimensionArray2[(chartDataViewSeriesArray.length + 1) * 2] == null) {
                                            String string = chartDataView.getPieChartFormat().getOtherLabel();
                                            dimensionArray2[(chartDataViewSeriesArray.length + 1) * 2] = new Dimension(this.symbolSize + this.smallGap, this.symbolSize + this.smallGap);
                                            dimensionArray2[(chartDataViewSeriesArray.length + 1) * 2 + 1] = new Dimension(dimensionArray.stringWidth(string) + this.smallGap, dimensionArray.getHeight() + this.smallGap);
                                        }
                                    } else {
                                        int n6 = ((PieData)object).percents[n5].index;
                                        if (n6 >= 0 && dimensionArray2[(n6 + 1) * 2] == null && chartDataViewSeriesArray[n6].isShowing && chartDataViewSeriesArray[n6].isShowingInLegend) {
                                            String string = chartDataViewSeriesArray[n6].getLabel();
                                            dimensionArray2[(n6 + 1) * 2] = new Dimension(this.symbolSize + this.smallGap, this.symbolSize + this.smallGap);
                                            dimensionArray2[(n6 + 1) * 2 + 1] = new Dimension(dimensionArray.stringWidth(string) + this.smallGap, dimensionArray.getHeight() + this.smallGap);
                                        }
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                        }
                    } else {
                        int n7 = 0;
                        while (n7 < chartDataViewSeriesArray.length) {
                            String string = chartDataViewSeriesArray[n7].getLabel();
                            if (chartDataViewSeriesArray[n7].isShowing && chartDataViewSeriesArray[n7].isShowingInLegend) {
                                object = null;
                                if (chartDataView.getChartType() == 9 && (object = chartDataViewSeriesArray[n7].getStyle().getFillStyle().getImage()) != null) {
                                    dimensionArray2[(n7 + 1) * 2] = new Dimension(((Image)object).getWidth(null) + this.smallGap, ((Image)object).getHeight(null) + this.smallGap);
                                    dimensionArray2[(n7 + 1) * 2 + 1] = new Dimension(dimensionArray.stringWidth(string) + this.smallGap, dimensionArray.getHeight() + this.smallGap);
                                } else {
                                    dimensionArray2[(n7 + 1) * 2] = new Dimension(this.symbolSize + this.smallGap, this.symbolSize + this.smallGap);
                                    dimensionArray2[(n7 + 1) * 2 + 1] = new Dimension(dimensionArray.stringWidth(string) + this.smallGap, dimensionArray.getHeight() + this.smallGap);
                                }
                            } else {
                                dimensionArray2[(n7 + 1) * 2] = null;
                                dimensionArray2[(n7 + 1) * 2 + 1] = null;
                            }
                            ++n7;
                        }
                    }
                }
            }
            ++n3;
        }
        this.rowHeights = new int[bl ? n2 + 1 : this.chart.data.size()];
        int n8 = 0;
        while (n8 < this.rowHeights.length) {
            this.rowHeights[n8] = 0;
            ++n8;
        }
        this.colWidths = new int[bl ? this.chart.data.size() : n2 + 1];
        int n9 = 0;
        while (n9 < this.colWidths.length) {
            this.colWidths[n9] = 0;
            ++n9;
        }
        this.symWidths = new int[bl ? this.chart.data.size() : n2 + 1];
        int n10 = 0;
        while (n10 < this.symWidths.length) {
            this.symWidths[n10] = 0;
            ++n10;
        }
        this.strWidths = new int[bl ? this.chart.data.size() : n2 + 1];
        int n11 = 0;
        while (n11 < this.strWidths.length) {
            this.strWidths[n11] = 0;
            ++n11;
        }
        int n12 = 0;
        while (n12 < this.labelSizes.length) {
            dimensionArray = (Dimension[])this.labelSizes[n12];
            if (dimensionArray != null) {
                int n13 = 0;
                while (n13 < dimensionArray.length) {
                    if (dimensionArray[n13] == null) {
                        dimensionArray[n13] = new Dimension(0, 0);
                    }
                    if (dimensionArray[n13 + 1] == null) {
                        dimensionArray[n13 + 1] = new Dimension(0, 0);
                    }
                    if (bl) {
                        if (n13 == 0) {
                            if (this.colWidths[n12] < dimensionArray[n13 + 1].width) {
                                this.colWidths[n12] = dimensionArray[n13 + 1].width;
                            }
                        } else {
                            if (this.symWidths[n12] < dimensionArray[n13].width) {
                                this.symWidths[n12] = dimensionArray[n13].width;
                            }
                            if (this.strWidths[n12] < dimensionArray[n13 + 1].width) {
                                this.strWidths[n12] = dimensionArray[n13 + 1].width;
                            }
                        }
                        if (this.rowHeights[n13 / 2] < dimensionArray[n13].height) {
                            this.rowHeights[n13 / 2] = dimensionArray[n13].height;
                        }
                        if (this.rowHeights[n13 / 2] < dimensionArray[n13 + 1].height) {
                            this.rowHeights[n13 / 2] = dimensionArray[n13 + 1].height;
                        }
                    } else {
                        if (this.rowHeights[n12] < dimensionArray[n13].height) {
                            this.rowHeights[n12] = dimensionArray[n13].height;
                        }
                        if (this.rowHeights[n12] < dimensionArray[n13 + 1].height) {
                            this.rowHeights[n12] = dimensionArray[n13 + 1].height;
                        }
                        if (this.symWidths[n13 / 2] < dimensionArray[n13].width) {
                            this.symWidths[n13 / 2] = dimensionArray[n13].width;
                        }
                        if (this.strWidths[n13 / 2] < dimensionArray[n13 + 1].width) {
                            this.strWidths[n13 / 2] = dimensionArray[n13 + 1].width;
                        }
                    }
                    n13 += 2;
                }
            }
            ++n12;
        }
        if (bl) {
            n = 0;
            while (n < this.colWidths.length) {
                if (this.colWidths[n] < this.symWidths[n] + this.strWidths[n]) {
                    this.colWidths[n] = this.symWidths[n] + this.strWidths[n];
                }
                ++n;
            }
        } else {
            if (this.colWidths[0] < this.strWidths[0]) {
                this.colWidths[0] = this.strWidths[0];
            }
            n = 1;
            while (n < this.colWidths.length) {
                if (this.colWidths[n] < this.symWidths[n] + this.strWidths[n]) {
                    this.colWidths[n] = this.symWidths[n] + this.strWidths[n];
                }
                ++n;
            }
        }
        this.ps.width += this.smallGap;
        this.ps.height += this.smallGap;
        n = 0;
        while (n < this.colWidths.length) {
            this.ps.width += this.colWidths[n];
            ++n;
        }
        int n14 = 0;
        while (n14 < this.rowHeights.length) {
            this.ps.height += this.rowHeights[n14];
            ++n14;
        }
        if (bl) {
            this.ps.width += (this.colWidths.length - 1) * this.betweenGap;
        } else {
            this.ps.height += (this.rowHeights.length - 1) * this.betweenGap;
        }
        this.needsRepaint = true;
        this.setChanged(false);
    }

    public boolean getChanged() {
        if (this.chart == null) {
            return super.getChanged();
        }
        int n = 0;
        while (n < this.chart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.chart.data.elementAt(n);
            if (chartDataView.isChanged()) {
                return true;
            }
            ++n;
        }
        return super.getChanged();
    }

    public synchronized void paintComponent(Graphics graphics) {
        int n;
        if (!this.isShowing) {
            return;
        }
        graphics = graphics.create();
        super.paintComponent(graphics);
        boolean bl = this.orientation == 1;
        int n2 = 0;
        int n3 = n = bl ? n2 + this.smallGap : n2 + this.smallGap;
        if (this.chart == null) {
            return;
        }
        int n4 = 0;
        while (n4 < this.chart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.chart.data.elementAt(n4);
            ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
            if (chartDataViewSeriesArray != null && chartDataViewSeriesArray.length != 0 && chartDataView.getIsShowingInLegend()) {
                String string;
                int n5;
                n += bl ? 0 : this.rowHeights[n4];
                int n6 = n5 = bl ? this.rowHeights[0] + n2 + this.smallGap : n2 + this.smallGap;
                if (graphics.getColor() != this.getForeground()) {
                    graphics.setColor(this.getForeground());
                }
                if ((string = chartDataView.getName()) == null) {
                    string = "";
                }
                if (bl) {
                    graphics.drawString(string, n, n5 - this.descent - this.smallGap - (this.rowHeights[0] - this.smallGap - this.symbolSize - this.descent) / 2);
                } else {
                    graphics.drawString(string, n5, n - this.descent - this.smallGap - (this.rowHeights[n4] - this.smallGap - this.symbolSize - this.descent) / 2);
                }
                Dimension[] dimensionArray = (Dimension[])this.labelSizes[n4];
                int n7 = 1;
                while (n7 < dimensionArray.length / 2) {
                    n5 += bl ? this.rowHeights[n7] : this.colWidths[n7 - 1];
                    if (dimensionArray[n7 * 2].width != 0 || dimensionArray[n7 * 2].height != 0 || dimensionArray[n7 * 2 + 1].width != 0 || dimensionArray[n7 * 2 + 1].height != 0) {
                        int n8;
                        int n9;
                        int n10;
                        if (bl) {
                            n10 = n;
                            n9 = n5;
                        } else {
                            n10 = n5;
                            n9 = n;
                        }
                        int n11 = bl ? this.rowHeights[n7] : this.rowHeights[n4];
                        int n12 = bl ? this.symWidths[n4] : this.symWidths[n7];
                        String string2 = null;
                        if (n7 <= chartDataViewSeriesArray.length) {
                            Image image = null;
                            string2 = chartDataViewSeriesArray[n7 - 1].getLabel();
                            n8 = 0;
                            int n13 = 0;
                            int n14 = 0;
                            if (chartDataView.getChartType() == 9 && (image = chartDataViewSeriesArray[n7 - 1].getStyle().getFillStyle().getImage()) != null) {
                                n8 = image.getWidth(null);
                                n13 = image.getHeight(null);
                                n14 = this.smallGap + n13 + (n11 - this.smallGap - n13) / 2;
                            } else {
                                n8 = this.symbolSize;
                                n13 = this.symbolSize;
                                n14 = this.descent + this.smallGap + n13 + (n11 - this.smallGap - n13 - this.descent) / 2;
                            }
                            int n15 = (n12 - this.smallGap - n8) / 2;
                            JCChartStyle jCChartStyle = chartDataViewSeriesArray[n7 - 1].getStyle();
                            switch (chartDataView.getChartType()) {
                                case 0: {
                                    jCChartStyle.getLineStyle().draw(graphics, n10 + n15, n9 - n11 + (n11 - this.smallGap - this.descent) / 2, n10 + n15 + this.symbolSize - 1, n9 - n11 + (n11 - this.smallGap - this.descent) / 2);
                                }
                                case 1: {
                                    jCChartStyle.getSymbolStyle().draw(graphics, n10 + n15 + this.symbolSize / 2, n9 - n11 + (n11 - this.smallGap - this.descent) / 2, this.symbolSize);
                                    break;
                                }
                                case 9: {
                                    if (image != null) {
                                        graphics.drawImage(image, n10 + n15, n9 - n14, null);
                                        break;
                                    }
                                }
                                case 8: 
                                case 10: 
                                case 11: {
                                    jCChartStyle.getFillStyle().fillOutlineRect(graphics, n10 + n15, n9 - n14, this.symbolSize - 1, this.symbolSize - 1, this.chart.chartArea.getForeground());
                                    break;
                                }
                                default: {
                                    jCChartStyle.getLineStyle().draw(graphics, n10 + n15, n9 - n11 / 2, n10 + this.symbolSize + 4, n9 - n11 / 2);
                                    break;
                                }
                            }
                        } else if (n7 == chartDataViewSeriesArray.length + 1) {
                            switch (chartDataView.getChartType()) {
                                case 11: {
                                    string2 = chartDataView.getPieChartFormat().getOtherLabel();
                                    int n16 = (n11 - this.symbolSize) / 2;
                                    if (n16 < 0) {
                                        n2 = 0;
                                    }
                                    n8 = this.descent + this.smallGap + this.symbolSize + (n11 - this.smallGap - this.symbolSize - this.descent) / 2;
                                    chartDataView.getPieChartFormat().getOtherStyle().getFillStyle().fillOutlineRect(graphics, n10 + (n12 - this.smallGap - this.symbolSize) / 2, n9 - n8, this.symbolSize - 1, this.symbolSize - 1, this.chart.chartArea.getForeground());
                                    break;
                                }
                            }
                        }
                        n10 += n12;
                        if (graphics.getColor() != this.getForeground()) {
                            graphics.setColor(this.getForeground());
                        }
                        if (n11 == this.symbolSize + this.descent + this.smallGap) {
                            graphics.drawString(string2, n10, n9 - this.descent - this.smallGap);
                        } else {
                            graphics.drawString(string2, n10, n9 - this.descent - this.smallGap - (n11 - this.smallGap - this.symbolSize - this.descent) / 2);
                        }
                    }
                    ++n7;
                }
                n += bl ? this.colWidths[n4] : 0;
                n += this.betweenGap;
            }
            ++n4;
        }
        graphics.dispose();
    }

    public Dimension preferredSize() {
        this.recalc();
        return new Dimension(this.ps);
    }

    JCDataIndex pick(Point point, ChartDataView chartDataView) {
        JCDataIndex jCDataIndex = null;
        boolean bl = this.orientation == 1;
        int n = -1;
        int n2 = this.smallGap;
        int n3 = 0;
        while (n3 < this.rowHeights.length) {
            if (point.y < (n2 += this.rowHeights[n3])) {
                n = n3;
                break;
            }
            ++n3;
        }
        int n4 = this.smallGap;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.colWidths.length) {
            if (point.x < (n4 += this.colWidths[n6])) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n < 0 || n5 < 0) {
            return null;
        }
        jCDataIndex = new JCDataIndex(-1, null, -1);
        jCDataIndex.obj = this;
        ChartDataView chartDataView2 = this.chart.getDataView(bl ? n5 : n);
        if (chartDataView != null && chartDataView2 != chartDataView) {
            return jCDataIndex;
        }
        jCDataIndex.dataView = chartDataView2;
        if (bl) {
            if (n > 0) {
                if (n - 1 < chartDataView2.getNumSeries()) {
                    jCDataIndex.series = chartDataView2.getSeries(n - 1);
                    jCDataIndex.seriesIndex = n - 1;
                } else {
                    jCDataIndex.series = null;
                    jCDataIndex.seriesIndex = -10;
                }
            }
        } else if (n5 > 0) {
            if (n5 - 1 < chartDataView2.getNumSeries()) {
                jCDataIndex.series = chartDataView2.getSeries(n5 - 1);
                jCDataIndex.seriesIndex = n5 - 1;
            } else {
                jCDataIndex.series = null;
                jCDataIndex.seriesIndex = -10;
            }
        }
        return jCDataIndex;
    }
}

